/* 
 *  GetInteractionDataRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.InteractionData;
import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.InteractionDataI;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.InteractionI;
import com.avaya.ccs.core.BaseInteraction;

import java.util.ArrayList;
import java.util.List;
import javafx.concurrent.WorkerStateEvent;  

public class GetInteractionDataRequest extends SessionRequest {

    private static final Logger LOG = Logger.getLogger(GetInteractionDataRequest.class);
    private final InteractionDataGUI gui;

    public GetInteractionDataRequest(InteractionDataGUI gui) {
        super(LOG);
        this.gui = gui;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        List<InteractionDataI> data = new ArrayList<>(); 
        List<InteractionI> interactions = new ArrayList<>();
        interactions.addAll(getSession().getInteractions());
        for (InteractionI i : interactions) {
            data.add((InteractionDataI) new InteractionData(i));
        }
        LOG.trace(methodName + "-");
        return data;
    }

    @Override
    public void setSucceeded() {
        this.setOnSucceeded((WorkerStateEvent t) -> {
            String methodName = "succeededHandler() ";
            // The value is returned from the call() method above so
            // will always be the correct type
            // The only way to check the type to avoid a warning is to
            // iterate over the list, instead suppress the warning
            @SuppressWarnings("unchecked")
            List<InteractionData> value = (List<InteractionData>) t.getSource().valueProperty().getValue();
            if (value != null) {
                LOG.debug(methodName + "List<InteractionData>:" + value);
                gui.UpdateInteractionData(value);
            } else {
                LOG.debug(methodName + " NULL");
            }
        });
    }
}
